//
//  GHRespirationData.h
//  Garmin Health
//
//  Created by Echeandia, Augie on 6/19/19.
//  Copyright © 2019 Garmin International. All rights reserved.
//

#import <Foundation/Foundation.h>

/**
 *  The GHRespirationData class provides information about respiration data that was extracted from the Garmin device.
 */
@interface GHRespirationData : NSObject

/**
*  Timestamp for when the data was created.
*  @note Can be null.
*/
@property (nullable, nonatomic, readonly) NSDate *timestamp;

/**
 *  Number of breaths taken for the interval where values of 0xFD indicates off wrist, 0xFE indicates
 *  large motion, and 0xFF indicates an invalid reading.
 *  @note Can be null.
 */
@property (nullable, nonatomic, readonly) NSNumber *breathsPerMinute;

@end
